// DeleteTimeZoneRange.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "DeleteTimeZoneRange.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// DeleteTimeZoneRange dialog


DeleteTimeZoneRange::DeleteTimeZoneRange(CWnd* pParent /*=NULL*/)
	: CDialog(DeleteTimeZoneRange::IDD, pParent)
{
	//{{AFX_DATA_INIT(DeleteTimeZoneRange)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}
DeleteTimeZoneRange ::DeleteTimeZoneRange(IApplication *pApp):CDialog(DeleteTimeZoneRange::IDD, NULL)
{
	pApplication = pApp;
	//pTZ.CreateInstance(__uuidof(TimeZone));
	
}

void DeleteTimeZoneRange::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(DeleteTimeZoneRange)
	DDX_Control(pDX, IDC_TZRANGELIST, m_TZRangeList);
	DDX_Control(pDX, IDC_TZLIST, m_TZList);
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	//}}AFX_DATA_MAP
}

void DeleteTimeZoneRange :: LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				m_AcctList.AddString(pAccount->AccountName);
				pAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	//m_AcctList.SetCurSel(0);
}

void DeleteTimeZoneRange ::LoadTimeZones()
{
		//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctName;
		m_AcctList.GetLBText(index,sAcctName);
		BSTR bstrAcctName = sAcctName.AllocSysString();

		_variant_t vTZs;
		vTZs.Clear();
		pApplication->GetTimeZonesByAccountName(bstrAcctName,&vTZs); // get timezone details of particular account  in WP-CS database server
		
		if(vTZs.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		ITimeZone *pTZ = NULL;
		
		COleSafeArray sa(vTZs);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ITimeZone,(void**)&pTZ);
			if (pTZ != NULL)
			{
				CString sTZid;
				sTZid.Format(L"%ld",pTZ->TimeZoneID);
				m_TZList.AddString(sTZid);
				pTZ->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_TZList.SetCurSel(0);
}

void DeleteTimeZoneRange ::LoadTimeZoneRanges()
{
		//select time zone id 
		int index = m_TZList.GetCurSel();
		CString sTZName;
		m_TZList.GetLBText(index,sTZName);
		long lTimeZoneID = _wtoi(sTZName);

		_variant_t vTZRanges;
		vTZRanges.Clear();
		pApplication->GetTimeZoneRangesByTZID(lTimeZoneID,&vTZRanges); // get timezone details of particular account  in WP-CS database server
		
		if(vTZRanges.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		ITimeZoneRange *pTZ = NULL;
		
		COleSafeArray sa(vTZRanges);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ITimeZoneRange,(void**)&pTZ);
			if (pTZ != NULL)
			{
				CString sTZid;
				sTZid.Format(L"%ld",pTZ->TZRangeID);
				m_TZRangeList.AddString(sTZid);
				pTZ->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_TZRangeList.SetCurSel(0);
}
BEGIN_MESSAGE_MAP(DeleteTimeZoneRange, CDialog)
	//{{AFX_MSG_MAP(DeleteTimeZoneRange)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	ON_CBN_SELCHANGE(IDC_TZLIST, OnSelchangeTzlist)
	ON_BN_CLICKED(IDC_DELETE, OnDelete)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// DeleteTimeZoneRange message handlers

BOOL DeleteTimeZoneRange::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	LoadAccounts();	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void DeleteTimeZoneRange::OnSelchangeAcctlist() 
{
	m_TZList.ResetContent();
	LoadTimeZones();
	
}

void DeleteTimeZoneRange::OnSelchangeTzlist() 
{
	m_TZRangeList.ResetContent();
	LoadTimeZoneRanges();
	
}

void DeleteTimeZoneRange::OnDelete() 
{
	int index_TZ = m_TZList.GetCurSel();
	CString sTZName;
	m_TZList.GetLBText(index_TZ,sTZName);
	long lTimeZoneID = _wtoi(sTZName);

	int index_TZRange = m_TZRangeList.GetCurSel();
	CString sTZRangeName;
	m_TZRangeList.GetLBText(index_TZRange,sTZRangeName);
	long lTimeZoneRangeID = _wtoi(sTZRangeName);
	long lStatus;
	pApplication->DeleteTimeZoneRange(lTimeZoneID,lTimeZoneRangeID,&lStatus);
	if (lStatus == 105)
	{
		AfxMessageBox(L"InValid Account");
		return;
	}
	if ( lStatus == 604)
	{
		AfxMessageBox(L"System Time zone can not be edited/deleted");
		return;
	}
	if(lStatus == 605)
	{
		AfxMessageBox(L"Invalid Time zone");
	}
	if(lStatus == 607)
	{
		AfxMessageBox(L"Invalid Time zone Range");
	}
	if(lStatus ==0)
	{
		AfxMessageBox(L"Time Zone Range Deletion succeeded");
		CDialog::OnOK();
	}
	if(lStatus ==1)
	{
		AfxMessageBox(L"Time Zone Range Deletion failed");
	}
}
